﻿$(function() {
	//创建see弹出框
	creatGrid();
	$('#answerDialog').dialog({
		title : 'answer information',
		closed : true,
		modal : true,
		shadow : false
	});
});

function creatGrid() {
	$('#askList').datagrid({
		fit : true,// 设置为true时铺满它所在的容器.
		fitColumns : true,// 设置为true将自动使列适应表格宽度以防止出现水平滚动
		nowrap : true,// 设置为true，当数据长度超出列宽时将会自动截取。
		striped : true,// 设置为true将交替显示行背景。
		collapsible : true,// 定义是否显示可折叠按钮。
		singleSelect : false,// 设置为true将只允许选择一行。
		border : false,
		remoteSort : false,// 定义是否通过远程服务器对数据排序。
		pagination : true,// 分页组件是否显示
		pageNumber : 1,// 起始页
		pageSize : 10,// 每页显示的记录条数，默认为10
		pageList : [ 10, 20, 50 ],// 每页显示多少行
		rownumbers : true,// 行号
		url : baseUrl + '/admin/Q010/listAskanswer.html',
		toolbar: '#tbar',
		frozenColumns : [ [ {
			field : 'select',
			title : 'select',
			width : 30,
			checkbox : true
		} ] ],
		columns : [ [ {
			sortable : true,
			sorter : datasort,
			field : 'lyname',
			title : 'source',
			width : 50,
			halign: 'center',
			align : 'left',
			formatter:namefrm	
		}, {
			sortable : true,
			sorter : datasort,
			field : 'title',
			title : 'Q&A title',
			width : 200,
			halign: 'center',
			align : 'left'
		}, {
			sortable : true,
			sorter : datasort,
			field : 'userName',
			title : 'questioner',
			width : 80,
			halign: 'center',
			align : 'left'
		},{
			sortable : true,
			sorter : datasort,
			field : 'insDate',
			title : 'question time',
			width : 150,
			align : 'center'
		},{
			sortable : true,
			sorter : datasort,
			field : 'acount',
			title : 'Answer number',
			width : 50,
			align : 'right'
		},
		{
			field : 'manage',
			title : 'manage',
			align : 'center',
			width : 100,
			formatter : fmup
		} ] ],
		// 当数据载入成功时触发。
		onLoadSuccess : function(data) {
			$('.edit_resource').linkbutton({
				iconCls : 'icon-edit',
				plain : true
			});
			$('.drop_resource').linkbutton({
				iconCls : 'icon-no',
				plain : true
			});

		}
	});
}

//查询
function findAsk() {
	var content=$("#TitleContent").val();
	var insUser=$("#asked").val();
	$('#askList').datagrid('load', {
		title: content,
		insUser:insUser
	});
}

//格式化日期
function fmdate(value, rowData, rowIndex) {
	if (value != null && value != '') {
		return fmtLongDate(new Date(value));
	}
	return "";
}
function namefrm(value, rowData, rowIndex){
	if(value != null && value != ''){
		return value;
	}else{
		return "self Q&A";
	}
}
//排序
function datasort(a, b) {
	return (a > b ? 1 : -1);
}

//按钮
function fmup(value, rowData, rowIndex) {
	var id = rowData.id;
	var str="<a onclick='answerDialog("+ id+ ")' class='edit_resource'>see</a>";
	str += "<a onclick='delAskById("+ id+ ");' class='drop_resource' >delete</a>";
	return str;
}

//删除问答提示
function delAnswerById(id) {
	$.messager.confirm('delete hint', 'make sure to delate this Q&A?', function(r) {
		if (r) {
			del(id);
		}
	});
}
//单个删除
function delAskById(mId) {
	$.messager.confirm('delete hint', 'make sure to delate this Q&A?', function(r) {
		if (r) {
			$.post(baseUrl + "/admin/Q010/deleteAskanswer.html", {
				id : mId
			}, function(data) {
				if (data > 0) {
					msgShow('delete success');
					reloadGrid();
				} else {
					msgShow('delete failure, please try again later');
					reloadGrid();
				}
			}, "json");
		}
	});
}
function del(mId){
	$.post(baseUrl + "/admin/Q010/deleteAskanswer.html", {
		id : mId
	}, function(data) {
		if (data > 0) {
			msgShow('delete success');
			reloadAnswerGrid();
		} else {
			msgShow('delete failure, please try again later');
			reloadAnswerGrid();
		}
	}, "json");
}
//多条删除
function delAsks() {
	var items_id = new Array();
	var items = $('#askList').datagrid('getSelections');
	if (items.length <= 0) {
		$.messager.alert('Hint', 'please select the Q&A need deleted', 'info');
		return;
	}
	// 获取选中消息的ID，并组成集合
	for ( var i = 0; i < items.length; i++) {
		items_id.push(items[i].id);
	}

	$.post(baseUrl + "/admin/Q010/deleteq010Askanswer.html", {
		mid : items_id
	}, function(data) {
		if (data > 0) {
			msgShow('delete success');
			reloadGrid();
		} else {
			msgShow('delete failure, please try again later');
			reloadGrid();
		}
	}, "json");
}

// 刷新提问列表
function reloadGrid() {
	$('#askList').datagrid('clearSelections');
	$('#askList').datagrid('reload');
}
//刷新回答列表
function reloadAnswerGrid() {
	$('#answerList').datagrid('clearSelections');
	$('#answerList').datagrid('reload');
}

function creatAnswerGrid(id) {
	$('#answerList').datagrid({
		fit : true,// 设置为true时铺满它所在的容器.
		fitColumns : true,// 设置为true将自动使列适应表格宽度以防止出现水平滚动
		nowrap : true,// 设置为true，当数据长度超出列宽时将会自动截取。
		striped : true,// 设置为true将交替显示行背景。
		collapsible : true,// 定义是否显示可折叠按钮。
		singleSelect : false,// 设置为true将只允许选择一行。
		border : false,
		remoteSort : false,// 定义是否通过远程服务器对数据排序。
		pagination : true,// 分页组件是否显示
		pageNumber : 1,// 起始页
		pageSize : 10,// 每页显示的记录条数，默认为10
		pageList : [ 10, 20, 50 ],// 每页显示多少行
		rownumbers : true,// 行号
		url : baseUrl + '/admin/Q010/lookOver.html?id='+id,
		columns : [ [ {
			field : 'ansUserName',
			title : 'answer name',
			width : 60,
			sortable : true,
			sorter : datasort,
			halign: 'center',
			align : 'left'
		}, {
			field : 'ansContent',
			title : 'answer content',
			width : 160,
			sortable : true,
			sorter : datasort,
			halign: 'center',
			align : 'left'
		}, {
			field : 'ansInsDate',
			title : 'answer time',
			width : 60,
			sortable : true,
			sorter : datasort,
			halign: 'center',
			align : 'center',
			formatter : fmdate
		},{
			field : 'manage',
			title : 'manage',
			width : 40,
			align : 'center',
			formatter : operate
		}] ],
		// 当数据载入成功时触发。
		onLoadSuccess : function(data) {
			$('.drop_answer').linkbutton({
				iconCls : 'icon-no',
				plain : true
			});
		}
	});
}
//操作
function operate(value, rowData, rowIndex) {
	var id = rowData.ansid;
	return "<a onclick='delAnswerById("+ id+ ");' class='drop_answer' >delete</a>";
}
//see
function answerDialog(id) {
	creatAnswerGrid(id);
	$('#answerDialog').dialog("open");
}